/**
 * Webview 端性能计时工具
 * 用于测量各个阶段的耗时
 */
export declare class PerformanceTimer {
    private static timers;
    private static durations;
    private static enabled;
    private static startTimestamp;
    private static pendingAsyncTasks;
    private static asyncTasksResolvers;
    /**
     * 启用/禁用性能计时
     */
    static setEnabled(enabled: boolean): void;
    /**
     * 重置起始时间戳
     */
    static resetStartTime(): void;
    /**
     * 获取从页面加载开始的时间
     */
    static getElapsedTime(): number;
    /**
     * 开始计时
     */
    static start(label: string): void;
    /**
     * 结束计时并打印耗时
     */
    static end(label: string): number;
    /**
     * 记录一个耗时（不需要 start/end）
     */
    static record(label: string, duration: number): void;
    /**
     * 标记异步任务开始
     */
    static startAsync(taskId: string): void;
    /**
     * 标记异步任务结束
     */
    static endAsync(taskId: string): number;
    /**
     * 等待所有异步任务完成
     */
    static waitForAsyncTasks(timeout?: number): Promise<void>;
    /**
     * 获取待完成的异步任务数量
     */
    static getPendingAsyncTaskCount(): number;
    /**
     * 获取已记录的耗时
     */
    static getDuration(label: string): number;
    /**
     * 清除所有计时器
     */
    static clear(): void;
    /**
     * 打印性能报告摘要
     */
    static summary(title: string): void;
    /**
     * 发送性能数据到 Extension 端（可选）
     */
    static report(): Record<string, number>;
    /**
     * 获取所有已记录的耗时
     */
    static getAllDurations(): Map<string, number>;
}
/**
 * React 组件渲染计时 Hook
 * 使用方法: 在组件顶部调用 useRenderTiming('ComponentName')
 */
export declare function useRenderTiming(componentName: string): void;
/**
 * 便捷的异步函数计时
 */
export declare function withTiming<T>(label: string, fn: () => Promise<T>): Promise<T>;
/**
 * 首次内容绘制 (FCP) 监控
 */
export declare function observeFCP(callback: (duration: number) => void): void;
/**
 * 最大内容绘制 (LCP) 监控
 */
export declare function observeLCP(callback: (duration: number) => void): void;
//# sourceMappingURL=performance.d.ts.map